% metoda zdruzenych gradientov Fletchera a Reevesa
% pre nahodnu kvadraticku funkciu

% rozmer ulohy
m = 20;

% nahodna nxn pomocna matica A
A = round(5*rand(m));

%nahodna kladne definitna symetricka matica G
G = ...

% nahodny nx1 vektor h
h = round(10*rand(m,1))-5;

% kvadraticka ucelova funkcia Q(x) = 1/2*x'Gx + h'x
Q = @(x) 1/2*x'*G*x + h'*x;

%gradient kvadratickej funkcie
gr = @(x) G*x + h;

% nahodny startovaci bod x
x0 = round(10*rand(m,1))-5;

% tolerancna konstanta eps
eps = 1e-6;

% maximalny povoleny pocet iteracii
n = 100;

% metoda Fletchera-Reevesa
x_fr = ...

%pocet iteracii
k = size(x_fr,2) - 1;

% urcenie funkcnych hodnot v iteracnych bodoch
f_fr = zeros(size(x_fr,2),1);
for i=1:size(x_fr,2)
f_fr(i) = Q(x_fr(:,i));
end
