function[x_iter] = SR1(G, gr, x, eps, n, m)

%inicializacia vektora iteracnych bodov
x_iter = x;

% inicializacia gradientu g a matice H
g = gr(x);
H = eye(m);

for k=1:n
    
    % testovanie presnosti: 
    if norm(g) < eps
        break;
    end
    
    % vypocet spadoveho smeru s
    s = ...
    
    % vypocet kroku lambda - optimalny pre kvadraticku funkciu
    lambda = ...
    
    % zapamatanie predchadzajucich hodnot 
    x0 = x;
    g0 = g;
    
    % vypocet novej aproximacie x
    x = x + lambda*s;
    
    % ulozenie novej aproximacie
    x_iter = [x_iter, x];
    
    % vypocet gradientu g
    g = gr(x);
    
    % vypocet pomocnych vektorov y a p
    y = ...
    p = ...
    
    % vypocet novej aproximacie H
    r = p - H*y;
    H = H + r*r'/(r'*y);
end
end