function[x_iter] = fletcher_reeves(G, gr, x, eps, n, m)

% inicializacia vektora s0 a cisla mu
s = zeros(m,1);
mu = 0;

%inicializacia vektorov pre vystup
x_iter = x;

for k=1:n
    
    % vypocet gradientu g
    g = gr(x);
    
    % testovanie presnosti
    if norm(g)<eps
        break; 
    end
    
    % vypocet spadoveho smeru s
    if k>1
        mu = ...
    end
    s = -g + mu*s;
    
    % vypocet kroku lambda - optimalny pre kvadraticku funkciu
    lambda = ...
    
    % zapamatanie predchadzajuceho gradientu
    g0 = g;
    
    % vypocet novej aproximacie
    x = ...
    
    %zapamatanie iteracie
    x_iter = [x_iter, x];
   
end
end