function[x_iter,Q_iter] = cauchy_kvadr(G,h,x0,eps,n)

%predpis kvadratickej funkcie
Q = @(x) .5*x'*G*x + h'*x;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% vykreslenie funkcie
[X,Y] = meshgrid(linspace(-10,10,101));
Z = zeros(size(X));
for i=1:size(X,1)
    for j=1:size(X,2)
        Z(i,j) = Q([X(i,j);Y(i,j)]);
    end
end

figure(1)
surfc(X,Y,Z,'EdgeColor','none');

figure(2)
contour(X,Y,Z)
hold on
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

x = x0;
x_iter = x0;
Q_iter = Q(x0);

% algoritmus
for k=1:n
    
    % vypocet gradientu g
    g = ...
    
    % testovanie presnosti
    if norm(g)<eps
        break; 
    end
    
    % vypocet smeru s
    s = ...
    
    % vypocet kroku lambda
    lambda = ...
    
    % vypocet novej aproximacie xnew
    xnew = ...
    
    % vykreslenie novej aproximacie
    plot([x(1) xnew(1)],[x(2) xnew(2)],'ko-')
    x = xnew;
    
    % zapamatanie novej aproximacie
    x_iter = [x_iter, x];
    Q_iter = [Q_iter, Q(x)];
   
end
hold off
end