function[x_iter,f_iter] = grad_back(f,gr,alpha,delta,x0,eps,n)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% vykreslenie funkcie
[X,Y] = meshgrid(linspace(-10,10,101));
Z = zeros(size(X));
for i=1:size(X,1)
    for j=1:size(X,2)
        Z(i,j) = f([X(i,j);Y(i,j)]);
    end
end

figure(1)
surfc(X,Y,Z,'EdgeColor','none');

figure(2)
contour(X,Y,Z)
hold on
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

x = x0;
x_iter = x0;
f_iter = f(x0);

% algoritmus
for k=1:n
    
    % vypocet gradientu
    g = ...
    
    % testovanie presnosti
    if norm(g)<eps
        break; 
    end
    
    % vypocet smeru s
    s = ...
    
    % vypocet kroku lambda pomocou backtrackingu
    lambda = 1;
    while ...
        lambda = delta*lambda;
    end
    
    % vypocet novej aproximacie
    xnew = ...
        
    % vykreslenie novej aproximacie
    plot([x(1) xnew(1)],[x(2) xnew(2)],'ko-')
    x = xnew;
    
    % zapamatanie novej aproximacie
    x_iter = [x_iter, x];
    f_iter = [f_iter, f(x)];
   
end
hold off
end