(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6299,        146]*)
(*NotebookOutlinePosition[      7699,        189]*)
(*  CellTagsIndexPosition[      7655,        185]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    RowBox[{"\n", 
      RowBox[{
        RowBox[{
          StyleBox["f",
            FontFamily->"Symbol"], ":=", "0.000001"}], ";", "\n", 
        RowBox[{"l1", "=", 
          RowBox[{
            StyleBox["{",
              FontFamily->"MT Extra",
              FontSize->12,
              FontWeight->"Bold",
              FontSlant->"Plain",
              FontColor->GrayLevel[0],
              FontVariations->{"Underline"->False,
              "StrikeThrough"->False}], 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["a",
                    FontSize->12,
                    FontWeight->"Bold",
                    FontSlant->"Plain",
                    FontColor->GrayLevel[0],
                    FontVariations->{"Underline"->False,
                    "StrikeThrough"->False}], "1"}]], ",", "a2", ",", "a3", 
              ",", "a4", ",", "a5", ",", "a6", ",", "a7", ",", "a8", ",", 
              "a9", ",", "a10", ",", "a11", ",", "a12", ",", "a13", ",", 
              "a14", ",", "a15", ",", "a16", ",", "a17", ",", "a18", ",", 
              "a19", ",", "a20", ",", "a21", ",", "a22", ",", "a23"}], 
            "}"}]}], ";", 
        \(x1 = {234, 638, 49, 36, 38, 19, 14, 29, 37, 9, 15, 24, 28, 4, 4, 
            13, 6, 3, 2, 1, 1, 1, 1}\), ";", "\n", 
        \(x2 = {5088.067, 4520.025, 959.995, 1027.087, 884.673, 735.323, 
            875.049, 548.702, 438.562, 670.529, 459.357, 362.898, 213.624, 
            247.788, 159.644, 131.420, 230.692, 96.76, 202.11, 193.372, 
            133.758, 250, 169.104}\), ";", "\n", 
        \(y1 = {109.964, 61.583, 30.943, 21.746, 14.911, 8.848, 10.756, 
            11.388, 7.736, 8.474, 7.649, 1.981, 1.832, 1.605, 2.414, 5.260, 
            4.071, 0.819, 5.586, 2.789, 4.324, 7, 4.839}\), ";", "\n", 
        \(y2 = {104.198, 142.027, 7.097, 28.685, 17.411, 15.212, 19.988, 
            13.443, 11.974, 29.129, 16.386, 4.624, 2.716, 6.867, 1.636, 
            4.960, 3.518, 1.230, 6.017, 2.327, 1.495, 4.000, 4.386}\), ";", 
        \(ind
           = {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
            1, 1}\), ";"}]}]], "Input",
  TextAlignment->Left,
  TextJustification->0],

Cell[BoxData[{
    StyleBox[\(CCRI\ model\  - \ vstupn\[AAcute]\ orient\[AAcute]cia\)], 
    RowBox[{"\t\t\t", 
      \(Do[Print[i, 
          ConstrainedMin[
            t - f*s1 - f*s2 - f*z1 - f*z2, {y1\ .l1 == y1[\([i]\)] + z1, 
              y2\ .l1 == y2[\([i]\)] + z2, t*x1[\([i]\)] - s1 == x1.\ l1, 
              t*x2[\([i]\)] - s2 == x2.l1, l1 >= 0, s1 >= 0, s2 >= 0, 
              z1 >= 0, z1 >= 0, z2 >= 0}, {t, a1, a2, a3, a4, a5, a6, a7, a8, 
              a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, 
              a22, a23, s1, s2, z1, z2}]], {i, 1, 23}]\)}]}], "Input"],

Cell[BoxData[{
    \(CCRO\ model - \ v\[YAcute]stupn\[AAcute]\ orient\[AAcute]cia\), 
    \(\t\t\t
    Do[Print[i, \ \ 
        ConstrainedMax[
          t - f*s1 - f*s2 - f*z1 - f*z2, {x1\ .l1 == x1[\([i]\)] - s1, 
            x2.l1 == x2[\([i]\)] - s2, t1*y1[\([i]\)] + z1 == y1.\ l1, 
            t1*y2[\([i]\)] + z2 == y2.l1, l1 >= 0, s1 >= 0, s2 >= 0, z1 >= 0, 
            z2 >= 0}, {t1, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, 
            a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, s1, s2, 
            z1, z2}]], {i, 1, 23}]\)}], "Input"],

Cell[BoxData[{
    \(BCCI\ model - \ vstupn\[AAcute]\ orient\[AAcute]cia\), 
    \(\t\t\t
    Do[Print[i, 
        ConstrainedMin[
          t - f*s1 - f*s2 - f*z1 - f*z2, {y1\ .l == y1[\([i]\)] + z1, 
            y2\ .l == y2[\([i]\)] + z2, t*x1[\([i]\)] - s1 == x1.\ l, 
            t*x2[\([i]\)] - s2 == x2.l, l >= 0, l.ind == 1, s1 >= 0, s2 >= 0, 
            z1 >= 0, z1 >= 0, z2 >= 0}, {t, a1, a2, a3, a4, a5, a6, a7, a8, 
            a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, 
            a22, a23, s1, s2, z1, z2}]], {i, 1, 23}]\)}], "Input"],

Cell[BoxData[{
    \(BCCO\ model - \ v\[YAcute]stupn\[AAcute]\ orient\[AAcute]cia\), 
    \(\t\t\t
    Do[Print[i\ \ , \ \ 
        ConstrainedMax[
          t1 + f*s1 + f*s2 + f*z1 + f*z2, {x1\ .l1 == x1[\([i]\)] - s1, 
            x2.l1 == x2[\([i]\)] - s2, t1*y1[\([i]\)] + z1 == y1.\ l1, 
            t1*y2[\([i]\)] + z2 == y2.l1, l1 >= 0, s1 >= 0, s2 >= 0, z1 >= 0, 
            z2 >= 0, l1.ind == 1}, {t1, a1, a2, a3, a4, a5, a6, a7, a8, a9, 
            a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, 
            a23, s1, s2, z1, z2}]], {i, 1, 23}]\)}], "Input"]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowToolbars->{},
WindowSize->{693, 426},
WindowMargins->{{0, Automatic}, {Automatic, 5}},
PrintingCopies->1,
PrintingStartingPageNumber->65,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PageFooters->{{Inherited, Inherited, Inherited}, {Inherited, Inherited, 65}},
PageHeaderLines->{False, Inherited},
PrintingOptions->{"PrintingMargins"->{{54, 54}, {72, 72}},
"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 2237, 47, 270, "Input"],
Cell[3949, 98, 607, 10, 150, "Input"],
Cell[4559, 110, 570, 10, 150, "Input"],
Cell[5132, 122, 572, 10, 100, "Input"],
Cell[5707, 134, 588, 10, 100, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

