int Test(Vektor bod)
// Funkcia testuje, ci bod[] splna podmienky :
// 		a[i] < x[i] < b[i]
// 		SUMA(xi) = 1

{
pom1=.0;
for(i=1;i<=rozmer-2;i++)
 { pom1+=bod[i];
   if ((bod[i]<ohr[1][i]) || (bod[i]>ohr[2][i])) return(2);
 }
if ((pom1<1-tol) || (pom1>1+tol)) return(3);
return(0);
}

double hoduc(Vektor bod)
	// Funkcia spocita hodnotu ucelovej funkcie v bod[]
{
double roz1=.0,roz2=.0;
pom1=pom2=.0;

	// Spocitanie yHy
MaticaVektor(KM,bod,pomv,rozmer-2);
sigma=VektorVektor(bod,pomv,rozmer-2);

	// Spocitanie mi*SUM[ln(xi-ai)-ln(bi-xi)]
for(i=1;i<=rozmer-2;i++)
 {
  roz1=bod[i]-ohr[1][i];
  roz2=ohr[2][i]-bod[i];
  if ( (roz1>0) && (roz2>0) ) pom2+=log(roz1)-log(roz2);
   else return(2);
 }
pom2 = mi*pom2;
return(sigma+pom2);
}

int Test_Start()
/* Funkcia testuje startovacie podmienky a Vracia hodnoty :
 0 - Nie je chyba
 1 - Chybne ohranicenia
 2 - Startovaci bod mimo ohraniceni
 3 - Porusenie podmienky SUMA(xi) = 1 (+- tol)
 4 - Pozadovana navratnost Er mimo povoleny intrval <min r[i], max r[i]>
 5 - Nesplnenie podmienky SUMA(xi*ri) = Er
*/

{
int dpoc=0, hpoc=0;

	//Testovanie ohraniceni : SUMA DOLNYCH <= 1 a SUMA HORNYCH >= 1
pom1=.0; pom2=.0;
for(i=1;i<=rozmer-2;i++)
 {pom1=pom1+ohr[1][i];
  pom2=pom2+ohr[2][i];
 }
if ((pom1>1.0) || (pom2<1.0)) return(1);

	// Volba startovacieho bodu lamda = (lamda1,lamda2)

y[rozmer-1] = 1.0;                  //lamda1
y[rozmer] = 1.0;                    //lamda2


	// Nastevenie tolerancie vychylky pri podmienkach
	// SUMA(xi) = 1  a  SUMA(xi*ri) = Er
tol = 0.01;

	// Testovanie startovacieho bodu : a[i]<x[i]<b[i] a SUMA(xi) = 1
co = Test(y);

	// Testovanie podmienky : SUMA(xi*ri) = Er
pom1 = VektorVektor(y,r,rozmer-2);
if ((pom1<Er-tol) || (pom1>Er+tol)) return(5);


	// "Odlepenie" startovacieho bodu od hranice v pripade "prilepenia"
	// Spocitanie poctu "prilepeni" na dolnu a hornu hranicu
for(i=1;i<=rozmer-2;i++)
 { if ( (y[i] > ohr[1][i]+tol) && (y[i] > ohr[2][i]-tol) ) hpoc++;
   if ( (y[i] < ohr[2][i]-tol) && (y[i] < ohr[1][i]+tol) ) dpoc++;
 }

	// Rzodiel poctu hornych a dolnych "prilepeni" a nasledne
	// "odlepenie" tak, aby nenastalo porusenie podmienky
	// SUMA(xi) = 1 +-tol
if ( (hpoc>0) || (dpoc>0) )
 {
   hpoc = abs(hpoc - dpoc);
   if (hpoc==0) hpoc=1;
   fprintf(s,"\n\nMenim startovaci bod (odlepenie od hranice intervalu) : \n");
   for(i=1;i<=rozmer-2;i++)
    {
     if ( (y[i] > ohr[1][i]+tol) && (y[i] > ohr[2][i]-tol) ) y[i]=y[i]-tol/hpoc;
     if ( (y[i] < ohr[2][i]-tol) && (y[i] < ohr[1][i]+tol) ) y[i]=y[i]+tol/hpoc;
    }
   for(i=1;i<=rozmer-2;i++) fprintf(s,"%14.12e ",y[i]);
 }

if (co == 2) return(2);
 else if (co==3) return(3);

	// Volba startovacieho bodu do funkcie cg()
for(i=1;i<=rozmer;i++) z[i]=y[i];

	// Testovanie podmienky : min r[i] < Er < max r[i]
pom1=10.0; pom2=.0;
for(i=1;i<=rozmer-2;i++)
 { if (r[i]<pom1) pom1=r[i];
   if (r[i]>pom2) pom2=r[i];
 }
if ((pom1>Er)||(pom2<Er)) return(4);

	// Nulovanie ynn
for(i=1;i<=rozmer;i++) ynn[i]=.0;

	// Vypocet normy startovacieho bodu
norma=norm(y,rozmer-2);

	// Nastavenie startovacich hodnot pre Newton iteracie
phu = hoduc(y);
hurozd = hu*2;
psigma = sigma;
srozd = sigma*2;

return(0);
}

void Vypis()
// Funkcia vypise do vystupoveho suboru nacitane udaje a startovaie parametre

{
fprintf(s,"\n\nParametre IPA :\n");
fprintf(s,"Rozmer kovariancnej matice (pocet aktiv)      = %d\n",rozmer-2);
fprintf(s,"Transformacny parameter                    mi = %f\n", mi);
fprintf(s,"Kriterium zastavenia Newton iteracii (kstop = %d) : \n",kstop);
if (kstop==1)
 fprintf(s,"        a) Absolutna presnost Newton rieseni  = %6.1e\n",keps);
 else if (kstop==2)
  fprintf(s,"        a) Absolutna presnost sigmy           = %6.1e\n",keps);
       else
  fprintf(s,"        a) Absolutna presnost  hodnoty F(y)   = %6.1e\n",keps);
fprintf(s,"        b) Max. povoleny pocet iteracii       = %d\n",niiter);
fprintf(s,"\nParametre Linear Solver (CG - Metoda zdruzenych gradientov) :\n");
fprintf(s,"Kriterium zastavenia CG iteracii :\n");
fprintf(s,"        a) Absolutna presnost (cgeps)         = %6.1e\n",cgeps);
fprintf(s,"        b) Max. povoleny pocet iteracii       = %d\n",cgiter);
fprintf(s,"\nVSTUPY : \n");
fprintf(s,"Kovariancna matica (%s): \n",mnazov);
for(i=1;i<=rozmer-2;i++)
 {
  for(j=1;j<=rozmer-2;j++) fprintf(s,"%14.12e ",KM[i][j]);
  fprintf(s,"\n");
 }
fprintf(s,"\nStartovaci bod : ");
for(i=1;i<=rozmer-2;i++) fprintf(s,"%14.12e ",y[i]);
fprintf(s,"\n\nVektor navratnosti' : ");
for(i=1;i<=rozmer-2;i++) fprintf(s,"%14.12e ",r[i]);
fprintf(s,"\n\nPozadovana navratnost = %14.12e\n",Er);
fprintf(s,"\nOhranicenia na riesenie : \n");
for(i=1;i<=rozmer-2;i++)
 {
  fprintf(s,"x[%d] je z <",i);
  fprintf(s,"%4f, ",ohr[1][i]);
  fprintf(s,"%4f>\n",ohr[2][i]);
 }
}

void Vypis_iter()
// Funkcia vypise udaje i-tej Newtonovej iteracie

{
fprintf(s,"\nMatica H =\n");
for(i=1;i<=rozmer;i++)
 {
  for(j=1;j<=rozmer;j++) fprintf(s,"%e ",H[i][j]);
  fprintf(s,"\n");
 }
fprintf(s,"\nVektor Fy = ");
for(i=1;i<=rozmer;i++) fprintf(s,"%e ",Fy[i]);
fprintf(s,"\nNewton mi : %e",mi);
switch (cgco)
 {
  case 0 : fprintf(s,"\n\nCG Pripad 0 - Presnost : %e (%d iteracii)",cgeps,cgi);break;
  case 1 : fprintf(s,"\n\nCG Pripad 1 - Iteracie! : %d",cgi);break;
 }
fprintf(s,"\nCG : Riesenie z = ");
for(i=1;i<=rozmer;i++) fprintf(s,"%e ",z[i]);
fprintf(s,"\nNewton RIESENIE ynn = ");
for (i=1;i<=rozmer;i++) fprintf(s,"%22.20f ",ynn[i]);
fprintf(s,"\nRozdiel dvoch poslednych rieseni : ");
for(i=1;i<=rozmer;i++) fprintf(s,"%e ",pomv[i]);
fprintf(s,"\nNorma rozdielu dvoch poslednych rieseni : %6.1e",norma);

	// Vypocet rozdielu poslednyh dvoch po sebe iducich hodnot
	// ucelovej funkcie
hurozd = phu - hu;
srozd = psigma - sigma;

fprintf(s,"\nHodnota ucelovej funkcie : %22.20f",hu);
fprintf(s,"\nRozdiel poslednych dvoch : %6.1e",hurozd);
if (hurozd < 0) fprintf(s," [-Hodnota ucelovej funkcie vzrastla]");
 else fprintf(s," [-Hodnota ucelovej funkcie klesla]");
fprintf(s,"\nSigma : %22.20f",sigma);
fprintf(s,"\nRozdiel poslednych dvoch : %6.1e",srozd);
if (srozd < 0) fprintf(s," [-Hodnota sigmy sa zvacsila !]\n");

	// Zapametanie si terajsej hodnoty ucelovej funkcie a sigma
phu = hu;
psigma = sigma;

}


void Koniec(int co)
// Funkia vypise do suboru hlasenie o tom, preo program skonil, vypoitane
// sledovane hodnoty a uvolni pamet

{
switch (co)
  {
   case 1 : fprintf(s,"\n\nChyba %d : Chybna volba ohraniceni.\n",co);break;
   case 2 : fprintf(s,"\n\nChyba %d : Bod mimo ohraniceni.\n",co);break;
   case 3 : fprintf(s,"\n\nChyba %d : Porusenie podmienky SUMA xi = 1 (+- tol).\n",co);break;
   case 4 : fprintf(s,"\n\nChyba %d : Er mimo povoleny intrval <min r[i], max r[i]>\n",co);break;
   case 5 : fprintf(s,"\n\nChyba %d : Nesplnenie podmienky SUMA(xi*ri) = Er+-%6.1e\n",co,tol);break;
   case 6 : fprintf(s,"\n\n%d : Dosiahnutie pozadovanej nieps presnosti %6.1e na %d Newton iteracii.\n",co,keps,ni-1);break;
   case 7 : fprintf(s,"\n\n%d : Dosiahnutie pozadovanej seps presnosti %6.1e na %d Newton iteracii.\n",co,keps,ni-1);break;
   case 8 : fprintf(s,"\n\n%d : Dosiahnutie pozadovanej hueps presnosti %6.1e na %d Newton iteracii.\n",co,keps,ni-1);break;
   case 9 : fprintf(s,"\n\n%d : Dosiahnutie povoleneho poctu %d Newton iteracii.\n",co,ni-1);break;
   case 10 : fprintf(s,"\n\nChyba %d : Rozmer matice je vacsi ako povolene maximum.\n",co);break;
   case 11 : fprintf(s,"\n\nChyba %d : Nepodarilo sa otvorit subor %s na citanie.\n",co,mnazov);break;
   case 12 : fprintf(s,"\n\nChyba %d : Nepodarilo sa otvorit subor %s na citanie.\n",co,onazov);break;
   case 13 : fprintf(s,"\n\nChyba %d : Nepodarilo sa vytvorit subor %s na zapis.\n",co,vystup);break;
  }

	// Ak bolo kriteriom zastavenia Newtonovych iteracii vyskocenie
	// riesenia z povoleneho intervalu, tak je pouzity predchadzajuci bod
if (co==2)
 {
  fprintf(s,"\nPouzivam riesenie ynn z predoslej iteracie %d : \n",ni-1);
  for(i=1;i<=rozmer-2;i++)
   {
     ynn[i]=y[i];
     fprintf(s,"%22.20f ",ynn[i]);
   }
 }

if (co<10)
 {
   pom1=pom2=.0;
   for(i=1;i<=rozmer-2;i++) pom1+=ynn[i]*r[i];
   fprintf(s,"\n\nZadana pozadovana navratnost Er = %14.12f\n",Er);
   fprintf(s,"Navratnost spocitana sucinom ynn*r = %14.12f",pom1);
   MaticaVektor(KM,ynn,pomv,rozmer-2);
   pom1=VektorVektor(ynn,pomv,rozmer-2);
   fprintf(s,"\nSigma [Sqrt( Riziko portfolia ) ] : %22.20f",pom1);
   fprintf(s,"\nRiziko portfolia : %22.20f",pom1*pom1);
   printf("\nPripad %d, ni = %d, pozri vystupny subor %s\n",co,ni,vystup);
  }

fclose(s);

for(i=1;i<=dim;i++) {free(KM[i]);}
for(i=1;i<=dim+2;i++) {free(H[i]);}
free(mnazov);free(onazov);free(vystup);
free(*KM);
free(*H);
free(r);free(y);free(ynn);free(Fy);free(z);free(d);free(suma);free(pomv);
//Uvolnovanie ohr[] robi hlasnie Null pointer assigment a niekedy aj zhodi BC31



free(ohr[1]);free(ohr[2]);
free(*ohr);
exit(co);
}